/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.task;

import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.ui.UIInfo;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.tree.SelectionTreeNode;
import com.ibm.hwmca.fw.util.tree.SimpleTreeNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PresentationTaskParms
implements Serializable {
    private ObjectId[] targetIds = null;
    private SelectionTreeNode rootSelection;
    private ObjectId taskId;
    private UserContext userContext;
    private UIInfo uiInfo;
    private String uiShortId;
    private Map metaData;
    private static final String TRACE_MASKT = "XFRMPTPT";
    private static final String TRACE_MASKF = "XFRMPTPF";
    private static final String TRACE_MASKD = "XFRMPTPD";
    public static final String TECHNOLOGY_SWING = "SWING";
    public static final String TECHNOLOGY_HTML = "HTML32";
    public static final String TECHNOLOGY_UNKNOWN = "UNKNOWN";
    public static final String TECHNOLOGY_FACADE = "HMC/AUIML_Facade-1.0";
    private String technologyType = "UNKNOWN";

    public PresentationTaskParms() {
        this(null);
    }

    public PresentationTaskParms(ObjectId taskId) {
        this(null, taskId);
    }

    public PresentationTaskParms(SelectionTreeNode rootSelection, ObjectId taskId) {
        this.rootSelection = rootSelection;
        this.taskId = taskId;
        if (this.rootSelection != null) {
            this.setTargetIds();
        }
    }

    public void setUIInfo(UIInfo uiInfo) {
        this.uiInfo = uiInfo;
    }

    public UIInfo getUIInfo() {
        return this.uiInfo;
    }

    public void setUIShortId(String uiShortId) {
        this.uiShortId = uiShortId;
    }

    public String getUIShortId() {
        return this.uiShortId;
    }

    protected void setTargetIds() {
        Trace.trace(TRACE_MASKT, "-> PresentationTaskParms.setTargetIds()");
        this.targetIds = null;
        List leaves = this.rootSelection.getLeaves();
        int size = leaves.size();
        this.rootSelection.dump();
        Trace.trace(TRACE_MASKT, "leaves size is: " + size);
        if (size > 0) {
            ArrayList<ObjectId> uniqueTargets = new ArrayList<ObjectId>();
            int i = 0;
            while (i < size) {
                ObjectId target;
                SelectionTreeNode node = (SelectionTreeNode)leaves.get(i);
                Trace.trace(TRACE_MASKT, "leaves #" + i + " is: " + node.getUserObject());
                if (!node.isRoot() && uniqueTargets.indexOf(target = (ObjectId)node.getUserObject()) == -1) {
                    uniqueTargets.add(target);
                }
                ++i;
            }
            size = uniqueTargets.size();
            if (size > 0) {
                this.targetIds = new ObjectId[size];
                int i2 = 0;
                while (i2 < size) {
                    this.targetIds[i2] = (ObjectId)uniqueTargets.get(i2);
                    ++i2;
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- PresentationTaskParms.setTargetIds()");
    }

    public void setTargetIds(ObjectId[] targetIds) {
        boolean foundTarget;
        Trace.trace(TRACE_MASKT, "-> PresentationTaskParms.setTargetIds(ObjectId[])");
        Trace.trace(TRACE_MASKF, "initial targets are:");
        int i = 0;
        while (this.targetIds != null && i < this.targetIds.length) {
            Trace.trace(TRACE_MASKF, "   target #" + i + " is: " + this.targetIds[i]);
            ++i;
        }
        if (this.targetIds != null) {
            i = 0;
            while (i < this.targetIds.length) {
                foundTarget = false;
                int j = 0;
                while (j < targetIds.length) {
                    if (this.targetIds[i].equals(targetIds[j])) {
                        foundTarget = true;
                        break;
                    }
                    ++j;
                }
                if (!foundTarget) {
                    Trace.trace(TRACE_MASKT, "removing target " + this.targetIds[i]);
                    if (this.rootSelection != null) {
                        this.rootSelection.removeNodesForUserObject(this.targetIds[i]);
                    }
                }
                ++i;
            }
        }
        i = 0;
        while (i < targetIds.length) {
            foundTarget = false;
            if (this.targetIds != null) {
                int j = 0;
                while (j < this.targetIds.length) {
                    if (targetIds[i].equals(this.targetIds[j])) {
                        foundTarget = true;
                        break;
                    }
                    ++j;
                }
            }
            if (!foundTarget) {
                Trace.trace(TRACE_MASKT, "adding target " + targetIds[i]);
                SelectionTreeNode newNode = new SelectionTreeNode(true, targetIds[i]);
                if (this.rootSelection == null) {
                    this.rootSelection = new SelectionTreeNode("root");
                }
                this.rootSelection.add(newNode);
            }
            ++i;
        }
        if (this.rootSelection != null) {
            this.setTargetIds();
        }
        Trace.trace(TRACE_MASKF, "new targets are:");
        int i2 = 0;
        while (this.targetIds != null && i2 < this.targetIds.length) {
            Trace.trace(TRACE_MASKF, "   target #" + i2 + " is: " + this.targetIds[i2]);
            ++i2;
        }
        Trace.trace(TRACE_MASKT, "<- PresentationTaskParms.setTargetIds(ObjectId[])");
    }

    public ObjectId[] getTargetIds() {
        ObjectId[] ids = null;
        if (this.targetIds != null) {
            ids = new ObjectId[this.targetIds.length];
            int i = 0;
            while (i < ids.length) {
                ids[i] = this.targetIds[i];
                ++i;
            }
        }
        return ids;
    }

    public void setSelections(SelectionTreeNode rootSelection) {
        this.rootSelection = rootSelection;
    }

    public ObjectId getTaskId() {
        return this.taskId;
    }

    public void setTaskId(ObjectId taskId) {
        this.taskId = taskId;
    }

    public ObjectId[] getGroupIds(ObjectId targetId) {
        ArrayList<ObjectId> groups = new ArrayList<ObjectId>();
        List nodes = this.rootSelection.getNodesForUserObject(targetId);
        int size = nodes.size();
        int i = 0;
        while (i < size) {
            SimpleTreeNode parent = ((SimpleTreeNode)nodes.get(i)).getParent();
            if (!parent.isRoot()) {
                groups.add((ObjectId)parent.getUserObject());
            }
            ++i;
        }
        ObjectId[] result = null;
        if (!groups.isEmpty()) {
            result = new ObjectId[groups.size()];
            groups.toArray(result);
        }
        return result;
    }

    public ObjectId[] getGroupIds() {
        ArrayList<ObjectId> groups = new ArrayList<ObjectId>();
        if (this.rootSelection != null) {
            List nodes = this.rootSelection.getLeaves();
            int size = nodes.size();
            int i = 0;
            while (i < size) {
                SimpleTreeNode parent = ((SimpleTreeNode)nodes.get(i)).getParent();
                if (!parent.isRoot() && !groups.contains(parent)) {
                    groups.add((ObjectId)parent.getUserObject());
                }
                ++i;
            }
        }
        ObjectId[] result = null;
        if (!groups.isEmpty()) {
            result = new ObjectId[groups.size()];
            groups.toArray(result);
        }
        return result;
    }

    public ObjectId[] getSelections() {
        List list = this.rootSelection.getSelectedNodes();
        int size = list.size();
        ObjectId[] result = new ObjectId[size];
        int i = 0;
        while (i < size) {
            SelectionTreeNode node = (SelectionTreeNode)list.get(i);
            result[i] = (ObjectId)node.getUserObject();
            ++i;
        }
        return result;
    }

    public ObjectId[] getSelections(ObjectId targetId) {
        List nodes = this.rootSelection.getFirstSelectedNodesForUserObject(targetId);
        int size = nodes.size();
        ObjectId[] result = new ObjectId[size];
        int i = 0;
        while (i < size) {
            SelectionTreeNode node = (SelectionTreeNode)nodes.get(i);
            result[i] = (ObjectId)node.getUserObject();
            ++i;
        }
        return result;
    }

    public UserContext getUserContext() {
        return this.userContext;
    }

    public List getGroupedTargetIds() {
        ArrayList<ObjectId[]> thelist = new ArrayList<ObjectId[]>();
        if (this.targetIds != null && this.targetIds.length > 0) {
            ArrayList<ObjectId> molist;
            Hashtable<String, ArrayList<ObjectId>> table = new Hashtable<String, ArrayList<ObjectId>>();
            ArrayList<ArrayList<ObjectId>> tablelist = new ArrayList<ArrayList<ObjectId>>();
            int i = 0;
            while (i < this.targetIds.length) {
                String classname = this.targetIds[i].getFullClassName();
                molist = (ArrayList<ObjectId>)table.get(classname);
                if (molist == null) {
                    molist = new ArrayList<ObjectId>();
                    table.put(classname, molist);
                    tablelist.add(molist);
                }
                molist.add(this.targetIds[i]);
                ++i;
            }
            int i2 = 0;
            while (i2 < tablelist.size()) {
                molist = (ArrayList)tablelist.get(i2);
                Object[] objs = molist.toArray();
                ObjectId[] mos = new ObjectId[objs.length];
                int j = 0;
                while (j < objs.length) {
                    mos[j] = (ObjectId)objs[j];
                    ++j;
                }
                thelist.add(mos);
                ++i2;
            }
        }
        return thelist;
    }

    public String getTechnologyType() {
        return this.technologyType;
    }

    public void setTechnologyType(String type) {
        if (!(type.equals(TECHNOLOGY_SWING) || type.equals(TECHNOLOGY_HTML) || type.equals(TECHNOLOGY_FACADE) || type.equals(TECHNOLOGY_UNKNOWN))) {
            throw new IllegalArgumentException("Invalid technology type " + type + " specified.");
        }
        this.technologyType = type;
    }

    public void trimTargetIds(Set targetIds) {
        Trace.trace(TRACE_MASKT, "-> PresentationTaskParms.trimTargetIds");
        String[] acceptableTypes = targetIds.toArray(new String[targetIds.size()]);
        Trace.trace(TRACE_MASKF, "acceptabletypes array size=" + acceptableTypes.length + ".");
        boolean allDone = false;
        do {
            ArrayList<ObjectId> goodTargets = new ArrayList<ObjectId>();
            ObjectId[] currentTargetIds = this.getTargetIds();
            if (currentTargetIds != null && currentTargetIds.length > 0) {
                Trace.trace(TRACE_MASKF, "target array size=" + currentTargetIds.length + ".");
                int i = 0;
                while (i < currentTargetIds.length) {
                    Trace.trace(TRACE_MASKF, "checking target #" + i + ":[" + currentTargetIds[i] + "]");
                    boolean acceptable = false;
                    int j = 0;
                    while (j < acceptableTypes.length && !acceptable) {
                        if (acceptableTypes[j].equals(currentTargetIds[i].getFullClassName())) {
                            Trace.trace(TRACE_MASKF, "target is acceptable");
                            acceptable = true;
                            goodTargets.add(currentTargetIds[i]);
                        }
                        ++j;
                    }
                    ++i;
                }
                if (currentTargetIds.length == goodTargets.size()) {
                    allDone = true;
                    continue;
                }
                ObjectId[] newTargets = goodTargets.toArray(new ObjectId[goodTargets.size()]);
                Trace.trace(TRACE_MASKF, "adjusted targets are:");
                int i2 = 0;
                while (i2 < newTargets.length) {
                    Trace.trace(TRACE_MASKF, "adjusted target #" + i2 + " is: " + newTargets[i2]);
                    ++i2;
                }
                this.setTargetIds(newTargets);
                continue;
            }
            Trace.trace(TRACE_MASKF, "no targets, so no need to trim anything.");
            allDone = true;
        } while (!allDone);
        Trace.trace(TRACE_MASKT, "<- PresentationTaskParms.trimTargetIds");
    }

    public void setData(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("The key argument is null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("The value argument is null.");
        }
        if (this.metaData == null) {
            this.metaData = new HashMap();
        }
        this.metaData.put(key, value);
    }

    public Object getData(String key) {
        if (key == null) {
            throw new IllegalArgumentException("The key argument is null.");
        }
        if (this.metaData == null) {
            return null;
        }
        return this.metaData.get(key);
    }

    public String toString() {
        String s = "[" + this.getClass().getName() + ";" + "Selections=[";
        if (this.rootSelection != null) {
            List nodes = this.rootSelection.getSelectedNodes();
            int size = nodes.size();
            int i = 0;
            while (i < size) {
                SelectionTreeNode node = (SelectionTreeNode)nodes.get(i);
                ObjectId userObject = (ObjectId)node.getUserObject();
                s = s + "#" + i + "=" + userObject.toString() + ";";
                ++i;
            }
        } else {
            s = s + "null";
        }
        s = s + "]; Targets=[";
        if (this.targetIds != null) {
            int i = 0;
            while (i < this.targetIds.length) {
                s = s + "#" + i + "=" + this.targetIds[i].toString() + ";";
                ObjectId[] groups = this.getGroupIds(this.targetIds[i]);
                s = s + "Group=[";
                if (groups != null) {
                    int j = 0;
                    while (j < groups.length) {
                        s = s + "#" + j + "=" + groups[j].toString() + ";";
                        ++j;
                    }
                } else {
                    s = s + "null];";
                }
                ++i;
            }
        } else {
            s = s + "null";
        }
        s = s + "]; Task=[";
        s = this.taskId != null ? s + this.taskId.toString() : s + "null";
        s = s + "]; User context=";
        s = this.userContext != null ? s + this.userContext.toString() : s + "[null]";
        s = s + "]; Technology type=[" + this.technologyType + "];";
        s = s + "]";
        return s;
    }
}

